<?php
$spaces = [
  ["id"=>"1YqJDqzRkzQGV","title"=>"Tech News Space","host"=>"@TechHost","status"=>"live","duration_minutes"=>45],
  ["id"=>"1OdKrBwZqYkGX","title"=>"Startup Talk","host"=>"@StartupLive","status"=>"scheduled","start_time"=>"2026-01-04T18:00:00"],
  ["id"=>"1mnxeRkPnAVGX","title"=>"Crypto & Markets","host"=>"@CryptoRoom","status"=>"live","duration_minutes"=>30]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>X Space Launcher PWA</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="manifest" href="manifest.json">
<meta name="theme-color" content="#1d9bf0">
<link rel="stylesheet" href="style.css">
</head>
<body>

<div class="wrapper">
<h1>🎧 X Spaces</h1>
<?php foreach($spaces as $s): ?>
<div class="space-card <?php echo $s['status']; ?>">
  <div class="status <?php echo $s['status']; ?>"><?php echo strtoupper($s['status']); ?></div>
  <div class="space-title"><?php echo htmlspecialchars($s['title']); ?></div>
  <div class="space-host">Host: <?php echo htmlspecialchars($s['host']); ?></div>
  <div class="actions">
    <button class="btn btn-open <?php echo $s['status']!=='live'?'disabled':''; ?>"
      <?php if($s['status']==='live'): ?>onclick="openSpace('<?php echo $s['id']; ?>')"<?php else: ?>disabled<?php endif; ?>>
      <?php echo $s['status']==='live'?'Join Live':'Scheduled'; ?>
    </button>
    <button class="btn btn-copy" onclick="copyLink('<?php echo $s['id']; ?>')">Copy Link</button>
  </div>
</div>
<?php endforeach; ?>
</div>

<div id="miniPlayer" class="mini-player">
<div class="mini-player-header">
  <span id="miniTitle">🎧 Space</span>
  <button onclick="restoreSpace()">⬆</button>
</div>
<iframe id="miniFrame"></iframe>
</div>

<script>
if('serviceWorker' in navigator){navigator.serviceWorker.register('/sw.js');}

const spacesData = <?php echo json_encode($spaces); ?>;

function openSpace(id){
  const url = "https://twitter.com/i/spaces/"+id;
  const title = document.querySelector(`.space-card [onclick*="${id}"]`).closest('.space-card').querySelector('.space-title').innerText;
  document.getElementById('miniFrame').src=url;
  document.getElementById('miniTitle').textContent=title;
  document.getElementById('miniPlayer').style.display='block';

  const isMobile=/Android|iPhone|iPad|iPod/i.test(navigator.userAgent);
  if(isMobile){ window.location.href=url; }
  else {
    const width=375,height=667,left=(screen.width/2)-(width/2),top=(screen.height/2)-(height/2);
    window.open(url,"xspaceMobile",`width=${width},height=${height},top=${top},left=${left},resizable=no,scrollbars=yes`);
  }
}

function copyLink(id){navigator.clipboard.writeText("https://twitter.com/i/spaces/"+id); alert("Space link copied");}
function restoreSpace(){document.getElementById('miniPlayer').style.display='none';}

// DRAG MINI PLAYER
let dragging=false,offsetX,offsetY;
const mini=document.getElementById('miniPlayer');
mini.addEventListener('mousedown',e=>{dragging=true;offsetX=e.clientX-mini.offsetLeft;offsetY=e.clientY-mini.offsetTop;});
document.addEventListener('mousemove',e=>{if(!dragging) return; mini.style.left=(e.clientX-offsetX)+'px'; mini.style.top=(e.clientY-offsetY)+'px'; mini.style.right='auto'; mini.style.bottom='auto';});
document.addEventListener('mouseup',()=>dragging=false);

// ===== REAL-TIME STATUS UPDATE =====
function updateSpaceStatus(){
  const now=new Date();
  document.querySelectorAll('.space-card').forEach(card=>{
    const statusElem=card.querySelector('.status');
    const btnOpen=card.querySelector('.btn-open');
    const id=btnOpen.getAttribute('onclick')?.match(/'([^']+)'/)[1];
    const space=spacesData.find(s=>s.id===id); if(!space) return;

    if(space.status==='scheduled'){
      const startTime=new Date(space.start_time);
      const diff=startTime-now;
      if(diff<=0){space.status='live'; statusElem.textContent='LIVE'; statusElem.className='status live'; btnOpen.disabled=false; btnOpen.classList.remove('disabled'); btnOpen.textContent='Join Live';}
      else{const mins=Math.floor(diff/60000),secs=Math.floor((diff%60000)/1000); statusElem.textContent=`Starts in ${mins}m ${secs}s`; statusElem.className='status scheduled';}
    }

    if(space.status==='live' && space.duration_minutes){
      const start=new Date(space.start_time||now);
      const end=new Date(start.getTime()+space.duration_minutes*60000);
      if(now>=end){space.status='ended'; statusElem.textContent='ENDED'; statusElem.className='status ended'; btnOpen.disabled=true; btnOpen.classList.add('disabled'); btnOpen.textContent='Ended';}
    }
  });
}
setInterval(updateSpaceStatus,1000);
updateSpaceStatus();
</script>

</body>
</html>
